//  oypu.h
//
//  Main module of the application.                                                  
//

#include "CyWin.h"

#define WHITE  0
#define L_GREY 1
#define D_GREY 2
#define BLACK  3

void init_session();
void move_piece(int);
void show_board();
void rotate_piece();
void make_new_yopu();
void show_yopu();

struct module_t main_module;           //  Main module of the application.

struct cDialog player_dialog;          //  CyWin dialog object.

bool exit_current_game;                //  TRUE if current game is finished. 
bool exit_game_session;                //  TRUE if program is finished.

bool need_new_yopu;

int your_score;                        //  Player's score.

int cursor_index;                      //  Cursor coordinate.
int player_mark_type;                  //  Type of the player's marks. 

int board_field[9];                    //  Board's fields.

char* ptr_background;                  //  Background image.

int move_number;                       //  Number of the current move.


const int yopus [10][2][1] = {
{ {WHITE},
  {WHITE} },

{ {L_GREY},
  {WHITE} },

{ {D_GREY},
  {WHITE} },

{ {BLACK},
  {WHITE} },

{ {L_GREY},
  {L_GREY} },

{ {D_GREY},
  {L_GREY} },

{ {BLACK},
  {L_GREY} },

{ {D_GREY},
  {D_GREY} },

{ {BLACK},
  {D_GREY} },

{ {BLACK},
  {BLACK} }

};

struct oypu_sprite {
       int color1;
       int color2;
       int bmp1_x;
       int bmp1_y;
       int bmp2_x;
       int bmp2_y;
       int orient;
} sprite;
